#-*- coding: utf-8 -*-

import traceback
import time
import pkg.bootstrap as bootstrap
from third_party.brain_client import BrainClient

'''
if has args register function, you can use it like this:
'''
def args_register_func(parser):
    parser.add_argument('--offset', type=int, default=0)

def check_pass(cli: BrainClient, alpha_id: str):
    alpha_detail = cli.get_alpha_detail(alpha_id)
    check_list = alpha_detail['is']['checks']
    is_pass = True
    for check in check_list:
        if check['result'] == 'FAIL':
            is_pass = False
    if is_pass:
        cli.set_favorite(alpha_id)
        cli.add_tag('pass', alpha_id)
        bootstrap.MLogger().info(f"{alpha_id} is pass, add to pass tag and favorite")
    else:
        bootstrap.MLogger().info(f"{alpha_id} is not pass")
def simulate_page(runtime: bootstrap.Runtime, cli: BrainClient, offset):
    bootstrap.MLogger().info(f"start simulate page, offset: {offset}")
    user_history_set = runtime.get('user_history_set')
    datafields_resp = cli.get_data_fields('fundamental6', offset)
    
    for item in datafields_resp['results']:
        field = item['id']
        expr = f"group_rank({field}/cap,industry)"
        if expr in user_history_set:
            bootstrap.MLogger().info(f"{field} is already in user history, skip")
            continue
        
        result = cli.simulate_fastexpr(expr)
        if 'alpha' not in result:
            bootstrap.MLogger().error(f"simulate {expr} with error, result: {result}")
            continue
        alpha_id = result['alpha']
        bootstrap.MLogger().info(f"simulate {expr}, alpha_id: {alpha_id}")
        check_pass(cli, alpha_id)
            
    return datafields_resp['count']

def build_user_history(cli: BrainClient, runtime: bootstrap.Runtime):
    offset = 0
    limit = 50
    count = offset + 1
    
    user_history_set = set()
    while offset < count:
        resp = cli.get_user_unsubmited_alphas(offset)
        count = resp['count']
        for item in resp['results']:
            expr = item['regular']['code']
            user_history_set.add(expr)
        time.sleep(1)
        offset += limit
    bootstrap.MLogger().info(f"had simulated expr count: {len(user_history_set)}")
    runtime.set('user_history_set', user_history_set)
    
# nohup python3 courses/day2/app.py --conf=conf/app.toml >> logs/0117.16.course2.log 2>&1 &
def main(runtime: bootstrap.Runtime):
    cli = BrainClient(runtime.config.brain.get('username'), runtime.config.brain.get('password'))
    
    offset = runtime.args.offset
    limit = 50
    count = offset+1
    
    bootstrap.MLogger().info(f"start work, offset: {offset}, limit: {limit}")
    
    build_user_history(cli, runtime)
    while offset < count:
        try:
            count = simulate_page(runtime, cli, offset)
        except Exception as e:
            exc = traceback.format_exc()
            bootstrap.MLogger().error('simulate page[offset={}] with error'.format(offset), e, exc)
        offset += limit


bootstrap.Bootstrap().opt_with_config().start(main, args_register_func)


