#-*- coding: utf-8 -*-
import time
import logging

class Logger:
    def __init__(self, prefix: str):
        self.prefix = prefix
    
    def log_at(self):
        return time.strftime("%Y-%m-%d %H:%M:%S", time.localtime(time.time()))
    def info(self, msg: str, *args, **kwargs):
        log_at = self.log_at()
        print(f"{log_at} [{self.prefix}/INFO] {msg}", *args, **kwargs)
    
    def error(self, msg: str, *args, **kwargs):
        log_at = self.log_at()
        print(f"{log_at} [{self.prefix}/ERROR] {msg}", *args, **kwargs)