#-*- coding: utf-8 -*-

import time
import requests

class staticConfig:
    host = "https://api.worldquantbrain.com"
    login = "/authentication"
    simulation = "/simulations"
    simulate_type = 'REGULAR'
    simulate_settings = {
            'instrumentType': 'EQUITY',
            'region': 'USA',
            'universe': 'TOP3000',
            'delay': 1,
            'decay': 0,
            'neutralization': 'INDUSTRY',
            'truncation': 0.08,
            'pasteurization': 'ON',
            'unitHandling': 'VERIFY',
            'nanHandling': 'OFF',
            'language': 'FASTEXPR',
            'visualization': False,
        }

class BrainClient:
    def __init__(self, username: str, password: str):
        self.username = username
        self.password = password
        self.conf = staticConfig()
        self.sess = self.login()

    def login(self) -> requests.Session: 
        sess = requests.Session()
        sess.auth = (self.username, self.password)
        login_url = self.conf.host + self.conf.login
        response = sess.post(login_url)
        if response.status_code != 201:
            print("login response: ", response.text)
            raise Exception("Login failed")
        return sess
    
    def post(self, url: str, body: dict = None) -> requests.Response:
        resp = self.sess.post(url, json=body)
        if resp.status_code == 401:
            self.update_session()
            resp = self.sess.post(url, json=body)
        return resp
    
    def get(self, url: str) -> requests.Response:
        resp = self.sess.get(url)
        if resp.status_code == 401:
            self.update_session()
            resp = self.sess.get(url)
        return resp
    
    # {'id': '3bHSZMfL74VKcq0S8AfLmxT', 'type': 'REGULAR', 'settings': {'instrumentType': 'EQUITY', 'region': 'USA', 'universe': 'TOP3000', 'delay': 1, 'decay': 0, 'neutralization': 'INDUSTRY', 'truncation': 0.08, 'pasteurization': 'ON', 'unitHandling': 'VERIFY', 'nanHandling': 'OFF', 'language': 'FASTEXPR', 'visualization': False}, 'regular': 'liabilities/assets', 'status': 'COMPLETE', 'alpha': 'ljwPdZl'}
    def simulate_fastexpr(self, regular: str) -> dict:
        body = {
            'type': self.conf.simulate_type,
            'settings': self.conf.simulate_settings,
            'regular': regular
        }

        simulate_url = self.conf.host + self.conf.simulation
        response = self.post(simulate_url, body)
        if response.status_code != 201:
            print("simulate response: ", response.text)
            raise Exception("Simulate failed")
        
        location = response.headers['Location']

        while True:
            r = self.get(location)
            retry_after_sec = float(r.headers.get("Retry-After", 0))
            if retry_after_sec == 0:
                break
            time.sleep(retry_after_sec)

        return r.json()
    