#-*- coding: utf-8 -*-

import json
import time
import traceback
import pkg.kernel as kernel

class RedisKey:
    EXPR_PENGDING_POOL = 'simulate_app:expr_pending_pool'
    

'''
if has args register function, you can use it like this:
'''
def args_register_func(parser):
    parser.add_argument('--interval', type=int, default=10, help='interval seconds')
    parser.add_argument('--title', type=str, default='', help='simulate title')
    parser.add_argument('--pool', type=str, default='expr_pending_pool', help='pending pool redis key')
    parser.add_argument('--retry_times', type=int, default=3, help='retry times')

'''
develop your application here
'''
def main():
    logger = kernel.logging('main')
    conn = kernel.data_engine_redis_conn()
    
    pool_key = RedisKey.EXPR_PENGDING_POOL
    if kernel.args().pool != '':
        pool_key = f'simulate_app:{kernel.args().pool}'
    logger.info(f"start simulate app, listen pool {pool_key} .....")
    
    while True:
        try:
            expr_data = fetch_pending(conn, pool_key)
            simulate(expr_data)
        except Exception as e:
            logger.error(f'listen with error: {e}')
            logger.error(traceback.format_exc())
            time.sleep(kernel.args().interval)

def simulate(expr_data: dict, retry_times: int = 0):
    logger = kernel.logging('simulate')
    expr = expr_data.get('expr')
    settings = expr_data.get('settings')
    logger.info(f"start simulate, expr: {expr}, simulate_settings: {settings}")
    
    try:    
        result = kernel.third_party_brain_client().simulate_fastexpr(expr, settings)
        is_pass = simulate_result_parse(expr_data, result)
        alpha_id = result['alpha']
        logger.info(f"simulate {expr}, alpha_id={alpha_id}, is_pass={is_pass}")
    except Exception as e:
        kernel.logging().error(traceback.format_exc())
        if retry_times < kernel.args().retry_times:
                retry_times += 1
                kernel.logging().error(f'simulate with error: {e}, expr: {expr_data}, retry_times: {retry_times}, retry...')
                time.sleep(kernel.args().interval)
                simulate(expr_data, retry_times)
        else:
            kernel.logging().error(f"simulate error: {e}, expr: {expr_data}, retry_times is max, give up...")
    
def simulate_result_parse(expr_data: dict, result: dict):
    if 'alpha' not in result:
        raise Exception(f'alpha field is not found, expr_data: {expr_data}, result: {result}')
    
    alpha_id = result['alpha']
    title = expr_data.get('title', '')
    is_pass = check_pass(alpha_id)
    patch_body = {}
    update = False
    if title != '':
        patch_body['tags'] = [title.replace(' ', '_')]
        update = True
    if is_pass:
        patch_body['color'] = 'GREEN'
        if 'tags' not in patch_body:
            patch_body['tags'] = []
        patch_body['tags'].append('pass')
        update = True
    
    if update:
        kernel.third_party_brain_client().patch_alpha(alpha_id, patch_body)
    return is_pass

def fetch_pending(conn, pool_key):
    
    while True:
        expr = conn.spop(pool_key)
        if expr is None:
            time.sleep(3)
            continue
        else:
            return json.loads(expr)

def check_pass(alpha_id: str):
    alpha_detail = kernel.third_party_brain_client().get_alpha_detail(alpha_id)
    check_list = alpha_detail['is']['checks']
    is_pass = True
    for check in check_list:
        if check['result'] == 'FAIL':
            is_pass = False
            break
    return is_pass

kernel.start(main, args_register_func)


