#-*- coding: utf-8 -*-

import pymysql
import redis
import sqlalchemy
import sqlalchemy.orm as orm
import sqlalchemy.ext.declarative as declarative
from dataclasses import dataclass

@dataclass
class MysqlConfig:
    host: str
    port: int
    username: str
    password: str
    database: str
    charset: str = 'utf8mb4'
    max_overflow: int = 0
    pool_size: int = 5
    pool_timeout: int = 30
    pool_recycle: int = 3600
    debug: bool = False

class Mysql:
    
    Base = declarative.declarative_base()
    def __init__(self, config: MysqlConfig):
        self.dsn = f'mysql+pymysql://{config.username}:{config.password}@{config.host}:{config.port}/{config.database}?charset={config.charset}'
        self.engine = sqlalchemy.create_engine(self.dsn, max_overflow=config.max_overflow, pool_size=config.pool_size, pool_timeout=config.pool_timeout, pool_recycle=config.pool_recycle, echo=config.debug)
        self.session_maker = orm.sessionmaker(bind=self.engine)
        
    def scope_session(self):
        return orm.scoped_session(self.session_maker)
        
    def with_migrate(self):
        Mysql.Base.metadata.create_all(self.engine)
        return self

    def with_migrate_drop(self):
        Mysql.Base.metadata.drop_all(self.engine)
        return self

@dataclass
class RedisConfig:
    host: str
    port: int
    password: str
    db: int = 0
    max_connections: int = 10
    debug: bool = False

class Redis:
    def __init__(self, config: RedisConfig):
        self.config = config
        self.pool = redis.ConnectionPool(host=config.host, port=config.port, password=config.password, db=config.db, max_connections=config.max_connections)
        
    def get_connection(self):
        return redis.StrictRedis(connection_pool=self.pool)