#-*- coding: utf-8 -*-
from redis.client import StrictRedis
import sqlalchemy.orm as orm
import pkg.bootstrap as bootstrap
import pkg.data_engine as data_engine
import pkg.logger as logger
import third_party.brain_client as brain_client
import argparse

class KernelKey:
    start_at = 'start_at'
    config = 'app.runtime.config'
    redis_engine = 'app.runtime.engine.redis'
    mysql_engine = 'app.runtime.engine.mysql'
    brain_client = 'app.runtime.client.brain'
    logger_template = 'app.runtime.logger'

__bootstrap__ = bootstrap.Bootstrap()

def get(key: str):
    if not __bootstrap__.runtime.get_global(KernelKey.start_at):
        raise Exception('runtime not start')
    return __bootstrap__.runtime.get(key)

def args() -> argparse.Namespace:
    if not __bootstrap__.runtime.get_global(KernelKey.start_at):
        raise Exception('runtime not start')
    return __bootstrap__.runtime.args
def config() -> bootstrap.Config:
    if not __bootstrap__.runtime.get_global(KernelKey.start_at):
        raise Exception('runtime not start')
    return __bootstrap__.runtime.config
def start(run_func, args_register_func=None):
    __bootstrap__.start(run_func, args_register_func)


def data_engine_redis_conn() -> StrictRedis:
    engine = get(KernelKey.redis_engine)
    if engine is None:
        app_config = config()
        engine = data_engine.Redis(data_engine.RedisConfig(**app_config.redis))
        __bootstrap__.runtime.set(KernelKey.redis_engine, engine)
    return engine.get_connection()

def data_engine_mysql_conn() -> orm.scoped_session:
    engine = get(KernelKey.mysql_engine)
    if engine is None:
        app_config = config()
        engine = data_engine.Mysql(data_engine.MysqlConfig(**app_config.mysql))
        __bootstrap__.runtime.set(KernelKey.mysql_engine, engine)
    return engine.scope_session()

def third_party_brain_client() -> brain_client.BrainClient:
    client = get(KernelKey.brain_client)
    if client is None:
        app_config = config()
        client = brain_client.BrainClient(app_config.third_party['brain']['username'], app_config.third_party['brain']['password'])
        __bootstrap__.runtime.set(KernelKey.brain_client, client)
    return client

def logging(module: str = ""):
    key = KernelKey.logger_template
    if module:
        key += f'.{module}'
    l = get(key)
    if l is None:
        l = logger.Logger(module)
        __bootstrap__.runtime.set(key, l)
    return l